import ManageQuestionsClient from "@/components/manage/ManageQuestionsClient";
import { FilePlus } from "lucide-react";

export default function ManagePage() {
    return (
        <div className="container mx-auto py-8 px-4 sm:py-12">
            <div className="flex flex-col sm:flex-row sm:items-center gap-4 mb-8">
                <div className="bg-primary/10 rounded-lg p-3 w-fit h-fit">
                    <FilePlus className="h-8 w-8 text-primary" />
                </div>
                <div>
                    <h1 className="text-3xl font-bold font-headline">Manage Questions</h1>
                    <p className="text-muted-foreground">Add, edit, or remove questions from the quiz bank.</p>
                </div>
            </div>
            <ManageQuestionsClient />
        </div>
    );
}
